<?php

use App\Models\Pixel;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\BrandController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\PixelController;
use App\Http\Controllers\RolesController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\StatistiquesController;


// -----------------------------------------------
use App\Http\Controllers\Admin\ContentTypeController;
use App\Http\Controllers\Admin\ContentEntryController;
use App\Http\Controllers\MediaController;
use App\Http\Controllers\Public\PublicContentController;
// -----------------------------------------------








Route::prefix('auth')->group(function () {
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/forget-passKey', [AuthController::class, 'forgetPassKey']);
    Route::post('/verify-code', [AuthController::class, 'verifyCodeForgetPassKey']);
    Route::post('/code-verification', [AuthController::class, 'loginAndVerifyCode']);
    Route::post('/change-password-forget', [AuthController::class, 'changePasswordForget']);
});


Route::prefix('client')->group(function () {
    Route::post('/blogs/search', [BlogController::class, 'searchClient']);
    Route::post('/categories/search', [CategoryController::class, 'searchClient']);
    Route::get('/products/searchFeatured', [ProductController::class, 'searchClientFeatured']);
    Route::post('/brands/search', [BrandController::class, 'searchClient']);
    Route::get('/brands/get/{slugOrId}', [BrandController::class, 'getOneClient']);


    Route::get('/reviews/search', [ReviewController::class, 'searchClient']);

    Route::post('/products/search', [ProductController::class, 'searchClient']);
    Route::get('/products/get/{id}', [ProductController::class, 'getClient']);
    Route::get('/blogs/get/{id}', [BlogController::class, 'getClient']);
    Route::post('/orders/create', [OrderController::class, 'createOrder']);
    Route::post('/contacts/create', [ContactController::class, 'create']);
});

Route::middleware('auth:sanctum')->group(function () {
    Route::get('/auth/current-user', [AuthController::class, 'getCurrentUser']);

    Route::prefix('role')->group(function () {
        Route::post('/create', [RolesController::class, 'create'])->middleware('checkPermission:roles,create');
        Route::put('/update/{id}', [RolesController::class, 'update'])->middleware('checkPermission:roles,update');
        Route::get('/search', [RolesController::class, 'search'])->middleware('checkPermission:roles,read');
        Route::get('/get/{id}', [RolesController::class, 'get'])->middleware('checkPermission:roles,read');
        Route::delete('/destroy/{id}', [RolesController::class, 'destroy'])->middleware('checkPermission:roles,delete');
    });

    Route::prefix('blogs')->group(function () {
        Route::post('/create', [BlogController::class, 'create'])->middleware('checkPermission:blogs,create');
        Route::post('/find', [BlogController::class, 'find'])->middleware('checkPermission:blogs,read');
        Route::put('/update/{id}', [BlogController::class, 'update'])->middleware('checkPermission:blogs,update');
        Route::post('/search', [BlogController::class, 'search'])->middleware('checkPermission:blogs,read');
        Route::get('/get/{id}', [BlogController::class, 'get'])->middleware('checkPermission:blogs,read');
        Route::delete('/destroy/{id}', [BlogController::class, 'destroy'])->middleware('checkPermission:blogs,delete');
    });

    Route::prefix('categories')->group(function () {
        Route::post('/create', [CategoryController::class, 'createCategory'])->middleware('checkPermission:categories,create');
        Route::put('/update/{id}', [CategoryController::class, 'updateCategory'])->middleware('checkPermission:categories,update');
        Route::post('/search', [CategoryController::class, 'search']);
        Route::delete('/destroy/{id}', [CategoryController::class, 'deleteCategory'])->middleware('checkPermission:categories,delete');
        Route::post('/importCategories', [CategoryController::class, 'importCategories'])->middleware('checkPermission:categories,create');
    });

    Route::prefix('orders')->group(function () {
        Route::put('/update/{orderId}', [OrderController::class, 'updateOrder'])->middleware('checkPermission:orders,update');
        Route::post('/search', [OrderController::class, 'search']);
        Route::delete('/destroy/{id}', [OrderController::class, 'destroy'])->middleware('checkPermission:orders,delete');
    });

    Route::prefix('contacts')->group(function () {
        Route::put('/update/{id}', [ContactController::class, 'update'])->middleware('checkPermission:contacts,update');
        Route::post('/search', [ContactController::class, 'search']);
        Route::delete('/destroy/{id}', [ContactController::class, 'delete'])->middleware('checkPermission:contacts,delete');
    });

    Route::prefix('products')->group(function () {
        Route::post('/create', [ProductController::class, 'create'])->middleware('checkPermission:products,create');
        Route::put('/update/{id}', [ProductController::class, 'update'])->middleware('checkPermission:products,update');
        Route::post('/search', [ProductController::class, 'search']);
        Route::delete('/destroy/{id}', [ProductController::class, 'delete'])->middleware('checkPermission:products,delete');
        Route::get('/get/{id}', [ProductController::class, 'get'])->middleware('checkPermission:products,read');
    });

    Route::prefix('brands')->group(function () {
        Route::post('/create', [BrandController::class, 'createBrand'])->middleware('checkPermission:brands,create');
        Route::put('/update/{id}', [BrandController::class, 'updateBrand'])->middleware('checkPermission:brands,update');
        Route::post('/search', [BrandController::class, 'search']);
        Route::delete('/destroy/{id}', [BrandController::class, 'delete'])->middleware('checkPermission:brands,delete');
        Route::post('/importBrands', [BrandController::class, 'importBrands'])->middleware('checkPermission:brands,create');
    });

    Route::prefix('subcategories')->group(function () {
        Route::post('/create', [CategoryController::class, 'createSubcategory'])->middleware('checkPermission:categories,create');
        Route::put('/update/{id}', [CategoryController::class, 'updateSubcategory'])->middleware('checkPermission:categories,update');
        Route::delete('/destroy/{id}', [CategoryController::class, 'deleteSubcategory'])->middleware('checkPermission:categories,delete');
        Route::post('/importCategories', [CategoryController::class, 'importSubCategories'])->middleware('checkPermission:categories,create');
    });


    Route::prefix('reviews')->group(function () {
        Route::post('/create', [ReviewController::class, 'create'])->middleware('checkPermission:reviews,create');
        Route::put('/update/{id}', [ReviewController::class, 'update'])->middleware('checkPermission:reviews,update');
        Route::delete('/destroy/{id}', [ReviewController::class, 'delete'])->middleware('checkPermission:reviews,delete');
        Route::post('/search', [ReviewController::class, 'search'])->middleware('checkPermission:reviews,create');
    });

    Route::prefix('pixels')->group(function () {
        Route::post('/store', [PixelController::class, 'store'])->middleware('checkPermission:pixels,create');
        Route::post('/emptyPixel', [PixelController::class, 'emptyPixel'])->middleware('checkPermission:pixels,delete');
        Route::post('/search', [PixelController::class, 'search'])->middleware('checkPermission:pixels,create');
    });

    Route::prefix('users')->group(function () {
        Route::post('/create',  [UsersController::class, 'create'])->middleware('checkPermission:users,create');
        Route::put('/update/{id}', [UsersController::class, 'update'])->middleware('checkPermission:users,update');
        Route::get('/search',  [UsersController::class, 'search'])->middleware('checkPermission:users,read');
        Route::get('/get/{id}', [UsersController::class, 'get'])->middleware('checkPermission:users,read');
        Route::delete('/destroy/{id}', [UsersController::class, 'destroy'])->middleware('checkPermission:users,delete');
        Route::put('/changePassword', [UsersController::class, 'changePassword']);
        Route::put('/updateProfile', [UsersController::class, 'updateProfile']);
        Route::get('/profile', [UsersController::class, 'getUserProfile']);
    });

    Route::post('/statistiques/CardsStats', [StatistiquesController::class, 'CardsStats']);
    Route::post('/statistiques/GraphsStats', [StatistiquesController::class, 'GraphsStats']);
});


// -----------------------------------------------

Route::prefix('client')->group(function () {
    Route::get('/content', [PublicContentController::class, 'show']);
});

Route::middleware(['auth:sanctum'])->prefix('admin')->group(function () {
    Route::apiResource('content-types', ContentTypeController::class);

    Route::get('content/{slug}/entries', [ContentEntryController::class, 'index']);
    Route::post('content/{slug}/entries', [ContentEntryController::class, 'store']);

    Route::put('content-entries/{entry}', [ContentEntryController::class, 'update']);
    Route::delete('content-entries/{entry}', [ContentEntryController::class, 'destroy']);

    Route::post('content-entries/{entry}/publish', [ContentEntryController::class, 'publish']);
    Route::post('content-entries/{entry}/unpublish', [ContentEntryController::class, 'unpublish']);



    Route::get('/media', [MediaController::class, 'index']);
    Route::post('/media/upload', [MediaController::class, 'upload']);
    Route::delete('/media/{id}', [MediaController::class, 'destroy']);
});

// -----------------------------------------------
