<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('roles')->insert([
            'name' => 'Admin',
            'description' => 'Administrator role',
            'permissions' => json_encode([
                [
                    'section' => 'users',
                    'access' => [
                        'create' => true,
                        'read' => true,
                        'update' => true,
                        'delete' => true
                    ],
                ],
                [
                    'section' => 'categories',
                    'access' => [
                        'create' => true,
                        'read' => true,
                        'update' => true,
                        'delete' => true
                    ],
                ],
                [
                    'section' => 'blogs',
                    'access' => [
                        'create' => true,
                        'read' => true,
                        'update' => true,
                        'delete' => true
                    ],
                ],
                [
                    'section' => 'roles',
                    'access' => [
                        'create' => true,
                        'read' => true,
                        'update' => true,
                        'delete' => true
                    ],
                ],
                [
                    'section' => 'products',
                    'access' => [
                        'create' => true,
                        'read' => true,
                        'update' => true,
                        'delete' => true
                    ],
                ],
                [
                    'section' => 'orders',
                    'access' => [
                        'create' => true,
                        'read' => true,
                        'update' => true,
                        'delete' => true
                    ],
                ],
                [
                    'section' => 'settings',
                    'access' => [
                        'create' => true,
                        'read' => true,
                        'update' => true,
                        'delete' => true
                    ],
                ],

            ]),
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }
}
