<?php

// database/migrations/xxxx_xx_xx_create_media_assets_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('media_assets', function (Blueprint $table) {
      $table->id();

      $table->string('name')->nullable();                 // display name
      $table->string('file_name');                        // remote file name
      $table->string('folder')->default('uploads');       // logical folder
      $table->string('url');                              // bunny public url
      $table->string('mime')->nullable();
      $table->unsignedBigInteger('size')->default(0);

      $table->unsignedInteger('width')->nullable();
      $table->unsignedInteger('height')->nullable();

      // multi-lingual optional
      $table->json('alt')->nullable();                    // {en:"", fr:"", ar:""}
      $table->json('title')->nullable();                  // {en:"", fr:"", ar:""}

      $table->unsignedBigInteger('created_by')->nullable();
      $table->softDeletes();
      $table->timestamps();

      $table->index(['folder']);
      $table->index(['created_by']);
    });
  }

  public function down(): void {
    Schema::dropIfExists('media_assets');
  }
};
