<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void
  {
    Schema::table('brands', function (Blueprint $table) {
      // SEO
      $table->string('meta_title')->nullable()->after('description');
      $table->text('meta_description')->nullable()->after('meta_title');

      // HERO (array of slides)
      $table->json('hero_slides')->nullable()->after('meta_description');

      // ABOUT section
      $table->string('about_title')->nullable()->after('hero_slides');
      $table->longText('about_text')->nullable()->after('about_title');
      $table->json('about_images')->nullable()->after('about_text'); // 3 images
      $table->json('about_stats')->nullable()->after('about_images'); // 3 stats
      $table->string('accent_color')->nullable()->after('about_stats'); // "#C4D457"
    });
  }

  public function down(): void
  {
    Schema::table('brands', function (Blueprint $table) {
      $table->dropColumn([
        'meta_title',
        'meta_description',
        'hero_slides',
        'about_title',
        'about_text',
        'about_images',
        'about_stats',
        'accent_color',
      ]);
    });
  }
};
