<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable(); 
            $table->unsignedBigInteger('category_id')->nullable(); 
            $table->unsignedBigInteger('subcategory_id')->nullable(); 
            $table->unsignedBigInteger('brand_id')->nullable(); 
            $table->string('reference')->unique(); 
            $table->enum('type', ['demander_devis', 'display_price']); // Product type
            $table->decimal('price', 10, 2)->nullable(); // Base price
            $table->decimal('compare_price', 10, 2)->nullable(); // Compare at price (original price)
            $table->integer('stock')->default(0); // Stock quantity
            $table->string('sku')->unique()->nullable(); // SKU (Stock Keeping Unit)
            $table->json('details')->nullable(); // Additional product details in JSON
            $table->json('images')->nullable(); // Store image paths as JSON
            $table->boolean('is_top_seller')->default(false); // Is product a top seller?
            $table->boolean('is_special_offer')->default(false); // Is product part of a special offer?
            $table->boolean('is_featured')->default(false); // Is product featured?
            $table->boolean('is_active')->default(true); // Active status
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraints
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('set null');
            $table->foreign('subcategory_id')->references('id')->on('sub_categories')->onDelete('set null');
            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
