<?php

namespace App\Services\Schema;

class LocaleResolver
{
    public function pick($value, string $locale, string $fallback)
    {
        if (is_array($value)) {
            if (array_key_exists($locale, $value)) return $value[$locale];
            if (array_key_exists($fallback, $value)) return $value[$fallback];

            // if something like {"en": "..."} and locale not found
            $first = reset($value);
            return $first;
        }

        return $value;
    }

    public function resolveData(array $schema, array $data, string $locale, string $fallback): array
    {
        $out = $data;

        foreach (($schema['fields'] ?? []) as $f) {
            $key = $f['key'] ?? null;
            if (!$key || !array_key_exists($key, $data)) continue;

            $type = $f['type'] ?? 'string';

            if ($type === 'repeater') {
                $items = is_array($data[$key]) ? $data[$key] : [];
                $subFields = $f['fields'] ?? [];

                $out[$key] = array_map(function ($item) use ($subFields, $locale, $fallback) {
                    if (!is_array($item)) return $item;

                    foreach ($subFields as $sf) {
                        $sk = $sf['key'] ?? null;
                        if (!$sk || !array_key_exists($sk, $item)) continue;

                        if (!empty($sf['localized'])) {
                            $item[$sk] = $this->pick($item[$sk], $locale, $fallback);
                        }
                    }

                    return $item;
                }, $items);

                continue;
            }

            if (!empty($f['localized'])) {
                $out[$key] = $this->pick($data[$key], $locale, $fallback);
            }
        }

        return $out;
    }
}
