<?php

namespace App\Providers;

use GuzzleHttp\Client;
use Illuminate\Support\ServiceProvider;
use App\Services\BunnyCDNService;

class BunnyCDNServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register()
    {
        $this->app->singleton(BunnyCDNService::class, function ($app) {
            return new BunnyCDNService(
                new Client(),
                env('BUNNYCDN_API_KEY'),
                env('BUNNYCDN_STORAGE_ZONE'),
                env('BUNNYCDN_URL_PREFIX')
            );
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
