<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SubCategory extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $dates = ['deleted_at'];

    protected $fillable = [
      'category_id' ,  'name' ,'description' ,'slug' , 'image' 
    ];

    public function blogs()
    {
        return $this->hasMany(Blog::class);
    }
      public function category()
    {
        return $this->belongsTo(Category::class);
    }
} 
