<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ContentType extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'is_single',
        'locales',
        'default_locale',
        'schema',
    ];

    protected $casts = [
        'is_single' => 'boolean',
        'locales' => 'array',
        'schema' => 'array',
    ];

    public function entries(): HasMany
    {
        return $this->hasMany(ContentEntry::class);
    }
}
