<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Brand extends Model
{
  use HasFactory, SoftDeletes;

  protected $fillable = [
    'name',
    'description',
    'slug',
    'image',
    'featured',

    // new
    'meta_title',
    'meta_description',
    'hero_slides',
    'about_title',
    'about_text',
    'about_images',
    'about_stats',
    'accent_color',
  ];

  protected $casts = [
    'hero_slides' => 'array',
    'about_images' => 'array',
    'about_stats' => 'array',
    'featured' => 'boolean',
  ];
}
