<?php

namespace App\Http\Controllers\Public;

use App\Http\Controllers\Controller;
use App\Http\Resources\Public\PublicContentResource;
use App\Services\Content\ContentDeliveryService;
use Illuminate\Http\Request;

class PublicContentController extends Controller
{
public function show(Request $request, ContentDeliveryService $delivery)
{
    $locale = (string) $request->query('locale', 'en');
    $fallback = (string) $request->query('fallback', 'en');

    $payload = $delivery->getPublicAll($locale, $fallback);

    return response()->json([
        "data" => $payload,
    ]);
}


    public function showSingle(Request $request, string $slug, ContentDeliveryService $delivery)
    {
        $locale = (string)$request->query('locale', 'en');
        $fallback = (string)$request->query('fallback', 'en');

        $payload = $delivery->getPublic($slug, $locale, $fallback);

        return new PublicContentResource($payload);
    }
}
